 *                                                                                  ;
 *    Reading in the 1976 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam76.raw' ;
 
 data one;
 
   infile 'F:\PSID\76FAM.DAT'  lrecl=1466 missover;
   INPUT
   V4301 1-3              V4302 4-7              V4303 8-9
   V4304 10-12            V4305 13-17            V4306 18
   V4307 19               V4308 20               V4309 21
   V4310 22               V4311 23               V4312 24
   V4313 25               V4314 26               V4315 27
   V4316 28               V4317 29-32            V4318 33-38
   V4319 39               V4320 40-44            V4321 45
   V4322 46-49            V4323 50               V4324 51
   V4325 52-55            V4326 56-59            V4327 60
   V4328 61               V4329 62               V4330 63-66
   V4331 67               V4332 68-71            V4333 72
   V4334 73-76            V4335 77               V4336 78-81
   V4337 82               V4338 83-86            V4339 87
   V4340 88-91            V4341 92               V4342 93-95
   V4343 96               V4344 97-100           V4345 101
   V4346 102-103          V4347 104              V4348 105-109 .2
   V4349 110-114          V4350 115-118          V4351 119
   V4352 120-123          V4353 124              V4354 125-128
   V4355 129              V4356 130              V4357 131-134
   V4358 135              V4359 136-139          V4360 140
   V4361 141              V4362 142-145          V4363 146
   V4364 147-150          V4365 151              V4366 152
   V4367 153-154          V4368 155-158          V4369 159
   V4370 160              V4371 161-165          V4372 166-170
   V4373 171-175          V4374 176              V4375 177-181
   V4376 182-186          V4377 187-191          V4378 192
   V4379 193-197          V4380 198              V4381 199-203
   V4382 204-208          V4383 209-213          V4384 214-218
   V4385 219-223          V4386 224-228          V4387 229
   V4388 230-234          V4389 235              V4390 236-240
   V4391 241-242          V4392 243-247          V4393 248
   V4394 249-253          V4395 254-258          V4396 259-263
   V4397 264-268          V4398 269-273          V4399 274-278
   V4400 279-283          V4401 284-288          V4402 289-293
   V4403 294              V4404 295-299          V4405 300-303
   V4406 304-308          V4407 309              V4408 310
   V4409 311-315          V4410 316-320          V4411 321-325
   V4412 326-330          V4413 331-335          V4414 336-340
   V4415 341-345          V4416 346-350          V4417 351-355
   V4418 356-360          V4419 361-365          V4420 366
   V4421 367              V4422 368              V4423 369-372
   V4424 373-376          V4425 377-380          V4426 381-384
   V4427 385-388          V4428 389-392          V4429 393-396
   V4430 397-400          V4431 401-409          V4432 410-411
   V4433 412              V4434 413-415          V4435 416-417
   V4436 418-419          V4437 420              V4438 421-422
   V4439 423-424          V4440 425-426          V4441 427
   V4442 428              V4443 429              V4444 430
   V4445 431              V4446 432              V4447 433-437
   V4448 438              V4449 439              V4450 440
   V4451 441              V4452 442              V4453 443-444
   V4454 445              V4455 446              V4456 447
   V4457 448              V4458 449              V4459 450-451
   V4460 452-453          V4461 454              V4462 455
   V4463 456              V4464 457-458          V4465 459
   V4466 460              V4467 461              V4468 462
   V4469 463-464          V4470 465              V4471 466
   V4472 467              V4473 468              V4474 469-470
   V4475 471              V4476 472              V4477 473-474
   V4478 475              V4479 476              V4480 477-479
   V4481 480              V4482 481              V4483 482
   V4484 483-484          V4485 485              V4486 486
   V4487 487              V4488 488-489          V4489 490-491
   V4490 492              V4491 493              V4492 494
   V4493 495              V4494 496              V4495 497
   V4496 498-499          V4497 500              V4498 501-502
   V4499 503-504          V4500 505              V4501 506-507
   V4502 508              V4503 509-510          V4504 511
   V4505 512-513          V4506 514              V4507 515-516
   V4508 517-518          V4509 519              V4510 520-522
   V4511 523              V4512 524-526          V4513 527-529
   V4514 530-532          V4515 533              V4516 534-536
   V4517 537              V4518 538              V4519 539-540
   V4520 541              V4521 542-544          V4522 545-546
   V4523 547-548          V4524 549              V4525 550-552
   V4526 553              V4527 554              V4528 555
   V4529 556              V4530 557-558          V4531 559
   V4532 560              V4533 561              V4534 562
   V4535 563              V4536 564-565          V4537 566
   V4538 567              V4539 568              V4540 569
   V4541 570              V4542 571-572          V4543 573
   V4544 574-576          V4545 577              V4546 578
   V4547 579              V4548 580              V4549 581
   V4550 582              V4551 583-584          V4552 585
   V4553 586-587          V4554 588-589          V4555 590
   V4556 591              V4557 592-593          V4558 594
   V4559 595-596          V4560 597              V4561 598
   V4562 599-600          V4563 601              V4564 602-603
   V4565 604              V4566 605-606          V4567 607
   V4568 608-609          V4569 610              V4570 611-612
   V4571 613-614          V4572 615-616          V4573 617
   V4574 618              V4575 619              V4576 620
   V4577 621-622          V4578 623-624          V4579 625-626
   V4580 627-628          V4581 629-630          V4582 631-632
   V4583 633              V4584 634              V4585 635
   V4586 636-637          V4587 638              V4588 639
   V4589 640              V4590 641              V4591 642-644
   V4592 645              V4593 646              V4594 647
   V4595 648              V4596 649              V4597 650
   V4598 651              V4599 652              V4600 653
   V4601 654              V4602 655              V4603 656
   V4604 657              V4605 658-659          V4606 660-661
   V4607 662-663          V4608 664-665          V4609 666-667
   V4610 668              V4611 669              V4612 670
   V4613 671              V4614 672              V4615 673
   V4616 674              V4617 675-678          V4618 679
   V4619 680              V4620 681              V4621 682
   V4622 683              V4623 684              V4624 685
   V4625 686              V4626 687              V4627 688
   V4628 689              V4629 690-691          V4630 692-693
   V4631 694-695          V4632 696-697          V4633 698
   V4634 699              V4635 700              V4636 701-702
   V4637 703-704          V4638 705-706          V4639 707-708
   V4640 709-710          V4641 711-712          V4642 713-714
   V4643 715-716          V4644 717              V4645 718
   V4646_1 719            V4646_2 720            V4647 721
   V4648 722              V4649 723              V4650_1 724
   V4650_2 725            V4651 726              V4652 727
   V4653 728              V4654 729              V4655 730-732
   V4656 733-735          V4657 736              V4658 737
   V4659 738-739          V4660 740-742          V4661 743-744
   V4662 745-747          V4663 748              V4664 749
   V4665 750              V4666 751-752          V4667 753-754
   V4668 755-756          V4669 757-758          V4670 759
   V4671 760              V4672 761              V4673 762
   V4674 763-764          V4675 765-767          V4676 768
   V4677 769              V4678 770              V4679 771
   V4680 772              V4681 773              V4682 774
   V4683 775              V4684 776-777          V4685 778
   V4686 779              V4687 780              V4688 781
   V4689 782              V4690 783              V4691 784
   V4692 785              V4693 786              V4694 787
   V4695 788-789          V4696 790              V4697 791
   V4698 792              V4699 793              V4700 794
   V4701 795              V4702 796              V4703 797-799
   V4704 800              V4705 801-803          V4706 804
   V4707 805              V4708 806-809          V4709 810
   V4710 811-814          V4711 815-818          V4712 819
   V4713 820-823          V4714 824-827          V4715 828-831
   V4716 832-835          V4717 836-839          V4718 840-843
   V4719 844-847          V4720 848              V4721 849-852
   V4722 853              V4723 854-857          V4724 858
   V4725 859-862          V4726 863              V4727 864-867
   V4728 868              V4729 869-871          V4730 872
   V4731 873-876          V4732 877-880          V4733 881-884
   V4734 885-888          V4735 889-892          V4736 893-896
   V4737 897-900          V4738 901-904          V4739 905-913
   V4740 914-915          V4741 916              V4742 917-919
   V4743 920-921          V4744 922-923          V4745 924-925
   V4746 926-927          V4747 928-929          V4748 930
   V4749 931              V4750 932              V4751 933-934
   V4752 935-937          V4753 938              V4754 939
   V4755 940-941          V4756 942              V4757 943
   V4758 944              V4759 945              V4760 946
   V4761 947              V4762 948              V4763 949-950
   V4764 951              V4765 952              V4766 953
   V4767 954              V4768 955-956          V4769 957
   V4770 958-959          V4771 960              V4772 961
   V4773 962-963          V4774 964              V4775 965-966
   V4776 967              V4777 968              V4778 969
   V4779_1 970            V4779_2 971            V4780 972-973
   V4781 974              V4782 975-976          V4783 977-978
   V4784 979-980          V4785 981-982          V4786 983
   V4787 984              V4788 985              V4789 986
   V4790 987-989          V4791 990              V4792 991
   V4793 992              V4794 993-995          V4795 996
   V4796 997-998          V4797 999-1000         V4798 1001-1002
   V4799 1003-1004        V4800 1005             V4801 1006-1007
   V4802 1008-1009        V4803 1010-1011        V4804 1012-1013
   V4805 1014-1015        V4806 1016-1017        V4807 1018-1019
   V4808 1020-1021        V4809 1022-1023        V4810 1024-1025
   V4811 1026-1027        V4812 1028-1029        V4813 1030-1031
   V4814 1032-1033        V4815 1034-1035        V4816 1036-1037
   V4817 1038-1039        V4818 1040             V4819 1041
   V4820 1042             V4821 1043             V4822 1044
   V4823 1045             V4824 1046             V4825 1047
   V4826 1048             V4827 1049             V4828 1050
   V4829 1051             V4830 1052             V4831 1053
   V4832 1054-1055        V4833 1056             V4834 1057
   V4835 1058             V4836 1059             V4837 1060
   V4838 1061             V4839 1062             V4840_1 1063
   V4840_2 1064           V4841 1065             V4842 1066-1067
   V4843 1068-1069        V4844 1070             V4845 1071
   V4846 1072             V4847 1073-1074        V4848 1075
   V4849 1076             V4850 1077             V4851 1078
   V4852 1079-1080        V4853 1081             V4854 1082
   V4855 1083             V4856 1084             V4857 1085-1086
   V4858 1087             V4859 1088             V4860 1089-1090
   V4861 1091             V4862 1092             V4863 1093-1095
   V4864 1096             V4865 1097             V4866 1098
   V4867 1099-1100        V4868 1101             V4869 1102
   V4870 1103             V4871 1104-1105        V4872 1106-1107
   V4873 1108             V4874 1109             V4875 1110
   V4876 1111             V4877 1112             V4878 1113
   V4879 1114-1115        V4880 1116             V4881 1117-1118
   V4882 1119-1120        V4883 1121             V4884 1122-1123
   V4885 1124             V4886 1125-1126        V4887 1127
   V4888 1128-1129        V4889 1130             V4890 1131-1132
   V4891 1133-1134        V4892 1135             V4893 1136-1138
   V4894 1139             V4895 1140-1142        V4896 1143-1145
   V4897 1146-1148        V4898 1149             V4899 1150-1152
   V4900 1153             V4901 1154             V4902 1155-1156
   V4903 1157             V4904 1158-1160        V4905 1161-1162
   V4906 1163-1164        V4907 1165             V4908 1166-1168
   V4909 1169             V4910 1170             V4911 1171
   V4912 1172             V4913 1173-1174        V4914 1175
   V4915 1176             V4916 1177             V4917 1178
   V4918 1179             V4919 1180-1181        V4920 1182
   V4921 1183             V4922 1184             V4923 1185
   V4924 1186             V4925 1187-1188        V4926 1189
   V4927 1190-1192        V4928 1193             V4929 1194
   V4930 1195             V4931 1196             V4932 1197
   V4933 1198             V4934 1199             V4935 1200-1201
   V4936 1202             V4937 1203-1204        V4938 1205-1206
   V4939 1207             V4940 1208             V4941 1209-1210
   V4942 1211             V4943 1212-1213        V4944 1214
   V4945 1215             V4946 1216-1217        V4947 1218
   V4948 1219-1220        V4949 1221             V4950 1222-1223
   V4951 1224             V4952 1225-1226        V4953 1227
   V4954 1228-1229        V4955 1230-1231        V4956 1232-1233
   V4957 1234             V4958 1235             V4959 1236
   V4960 1237             V4961 1238-1239        V4962 1240-1241
   V4963 1242-1243        V4964 1244-1245        V4965 1246-1247
   V4966 1248-1249        V4967 1250             V4968 1251
   V4969 1252             V4970 1253-1254        V4971 1255
   V4972 1256             V4973 1257             V4974 1258
   V4975 1259-1261        V4976 1262             V4977 1263
   V4978 1264             V4979 1265             V4980 1266
   V4981 1267             V4982 1268             V4983 1269
   V4984 1270             V4985 1271             V4986 1272
   V4987 1273             V4988 1274             V4989 1275-1276
   V4990 1277-1278        V4991 1279-1280        V4992 1281
   V4993 1282-1283        V4994 1284             V4995 1285
   V4996 1286             V4997 1287-1288        V4998 1289-1290
   V4999 1291-1292        V5000 1293-1294        V5001 1295-1296
   V5002 1297-1298        V5003 1299-1300        V5004 1301-1302
   V5005 1303             V5006 1304             V5007_1 1305
   V5007_2 1306           V5008 1307             V5009 1308
   V5010 1309             V5011_1 1310           V5011_2 1311
   V5012 1312             V5013 1313             V5014 1314
   V5015 1315             V5016 1316-1318        V5017 1319-1321
   V5018 1322             V5019 1323             V5020 1324
   V5021 1325             V5022 1326             V5023 1327
   V5024 1328             V5025 1329             V5026 1330
   V5027 1331             V5028 1332             V5029 1333-1337
   V5030 1338             V5031 1339-1343        V5032 1344
   V5033 1345             V5034 1346             V5035 1347
   V5036 1348             V5037 1349             V5038 1350
   V5039 1351             V5040 1352             V5041 1353
   V5042 1354             V5043 1355             V5044 1356-1360
   V5045 1361             V5046 1362             V5047 1363-1366 .2
   V5048 1367             V5049 1368-1371        V5050 1372-1375 .2
   V5051 1376             V5052 1377-1380 .2     V5053 1381
   V5054 1382             V5055 1383             V5056 1384
   V5057 1385             V5058 1386             V5059 1387
   V5060 1388-1389        V5061 1390-1391        V5062 1392-1396
   V5063 1397             V5064 1398             V5065 1399
   V5066 1400             V5067 1401             V5068 1402-1403 .1
   V5069 1404             V5070 1405-1406        V5071 1407
   V5072 1408             V5073 1409             V5074 1410
   V5075 1411             V5076 1412-1414        V5077 1415
   V5078 1416             V5079 1417             V5080 1418
   V5081 1419             V5082 1420             V5083 1421
   V5084 1422             V5085 1423             V5086 1424
   V5087 1425             V5088 1426-1427        V5089 1428-1430
   V5090 1431-1432        V5091 1433-1434        V5092 1435-1436
   V5093 1437-1439        V5094 1440-1441        V5095 1442-1443
   V5096 1444             V5097 1445             V5098 1446
   V5099 1447-1448        V5100 1449             V5101 1450
   V5102 1451             V5103 1452             V5104 1453
   V5105 1454             V5106 1455             V5107 1456
   V5108 1457             V5109 1458             V5110 1459
   V5111 1460             V5112 1461             V5113 1462-1465
   V5114 1466;

* SAS LABEL STATEMENT;

LABEL
   V4301 = "STUDY NUMBER (768)   6V1"
   V4302 = "1976 ID NUMBER       6V2"
   V4303 = "STATE NOW            6V3"
   V4304 = "COUNTY NOW           6V4"
   V4305 = "STATE &  COUNTY NOW   6V5"
   V4306 = "SIZE LGST CITY PSU   6V6"
   V4307 = "COLOR OF COVERSHEET  6V7"
   V4308 = "WHTHER ORIG  REFUSED 6V8"
   V4309 = "TELE INTERVIEW       6V9"
   V4310 = "FAM COMP CHANGE     6V10"
   V4311 = "NUMBER MOVED IN     6V11"
   V4312 = "WHO MOVED IN        6V12"
   V4313 = "NUMBER MOVED OUT    6V13"
   V4314 = "WHO MOVED OUT       6V14"
   V4315 = "CURRENT FAM COMP    6V15"
   V4316 = "QUALITY OF MATCH    6V16"
   V4317 = "SPLOF H& W INT MATCH 6V17"
   V4318 = "HOUSE VALUE 1976      C4"
   V4319 = "ACC HOUSE VALUE     6V19"
   V4320 = "REM MORT PRINCIPAL    C6"
   V4321 = "ACC REM MORT PRINC  6V21"
   V4322 = "ANNUAL MORT PMT       C7"
   V4323 = "ACC ANNUAL MORT PMT 6V23"
   V4324 = "WHETHER TAX INCLUD   C10"
   V4325 = "ANNUAL PROP TAXES    C11"
   V4326 = "ANNUAL RENT          C12"
   V4327 = "ACC ANNUAL RENT     6V27"
   V4328 = "WHETH HEAT INCLUD    C13"
   V4329 = "WHETH DU RENT FURN   C14"
   V4330 = "ANNUAL VALU IF RENT  C16"
   V4331 = "ACC ANN VAL IF RENT 6V31"
   V4332 = "ANN WORK HOURS      6V32"
   V4333 = "ACC ANN WK HOURS    6V33"
   V4334 = "ANN ILL HRS OTHERSD40E21"
   V4335 = "ACC ANN ILL HRS OT  6V35"
   V4336 = "ANN ILL HRS SELF  D42E23"
   V4337 = "ACC ANN ILL HRS SELF6V37"
   V4338 = "ANN UNEMPLOYMENT  D49E27"
   V4339 = "ACC ANN UNEMPLOY    6V39"
   V4340 = "ANN STRIKE HOURS  D47E25"
   V4341 = "ACC ANN STRIKE HRS  6V41"
   V4342 = "HD ANN TRAVL TO WKHR6V42"
   V4343 = "ACC H ANN TRAV WRK  6V43"
   V4344 = "WIFE ANN WORK HRS   G5G6"
   V4345 = "ACC WIFE ANN WRK H  6V45"
   V4346 = "FAMILY SIZE         6V46"
   V4347 = "NUMBER REQUIR RMS   6V47"
   V4348 = "WEEKLY FOOD NEED    6V48"
   V4349 = "ANNUAL NEED STAND   6V49"
   V4350 = "ANN HRS HSEWRK HEAD   G7"
   V4351 = "ACC ANN HSEWRK HEAD 6V51"
   V4352 = "ANN HSEWRK HRS OTH   G11"
   V4353 = "ACC ANN HRS HWRK OT 6V53"
   V4354 = "ANN FOOD EXPENDITRG13G15"
   V4355 = "ACC ANN FOOD EXPEN  6V55"
   V4356 = "# PERS FD STM ISSU   G17"
   V4357 = "$  PAID FOR STAMPS    G18"
   V4358 = "ACC $  PAID LAST MON 6V58"
   V4359 = "$  SAV FDSTAM LASTMO  G19"
   V4360 = "ACC $  SAVED LAST MO 6V60"
   V4361 = "WHET G13 INCL FDSTMP G20"
   V4362 = "$  SPENT FDSTA LASTYR G22"
   V4363 = "ACC $  PAID FS 1975  6V63"
   V4364 = "$  SAV FDSTAMP 1975G22G23"
   V4365 = "ACC $  SAV FDST  75  6V65"
   V4366 = "FDSTAMP ALL OF 75    G24"
   V4367 = "# MO FDSTAMP IN 75   G25"
   V4368 = "$  SPENT MEALS OUT 75 G26"
   V4369 = "ACC $  SPENT MEALS OUTV69"
   V4370 = "# MAJOR ADULTS      6V70"
   V4371 = "LABOR FARM INCOME     H4"
   V4372 = "LABOR BUSIN INCOM     H7"
   V4373 = "ANNUAL WAGES          H8"
   V4374 = "ACC ANNUAL WAGES    6V74"
   V4375 = "BONUS OT COMMISSIO   H10"
   V4376 = "PROF PRAC OR TRADE  H11A"
   V4377 = "LABOR ROOMERS ETC   H11B"
   V4378 = "ACC V71V72V75-V77   6V78"
   V4379 = "WIFES ANNUAL WAGE    H25"
   V4380 = "ACC WIFES ANN WAG   6V80"
   V4381 = "ASSET FARM INCOME     H4"
   V4382 = "ASSET BUSI INCOME     H7"
   V4383 = "ASSET ROOMERS ETC   H11B"
   V4384 = "RENT INTER DIVIDEND H11C"
   V4385 = "WIFES ASSET INCOME   H25"
   V4386 = "TAXABLE INCOME H& W  6V86"
   V4387 = "ACC V81-V85         6V87"
   V4388 = "SUP OTH OUTSIDE FUH43-47"
   V4389 = "# OF DEPENDENTS     6V89"
   V4390 = "TOTAL 75 TAXES H& W  6V90"
   V4391 = "MARGINAL TAX RATE   6V91"
   V4392 = "ANNUAL ADC AFDC H& W H11D"
   V4393 = "ACC ANN ADC AFDC    6V93"
   V4394 = "ANN OTH WELFARE H& W H11E"
   V4395 = "ANN SOC SECURITYH& W H11F"
   V4396 = "ANN OTH RETIRE HEAD H11G"
   V4397 = "HD  UNEMP WRK COMP  H11H"
   V4398 = "HD  ALIM,CHILD SUPP H11I"
   V4399 = "HD  HELP FROM REL   H11J"
   V4400 = "HD  SUPPLE SECURIT  H11K"
   V4401 = "HD  ANYTHING ELSE   H11M"
   V4402 = "ANN WIFES TRANSFER   H25"
   V4403 = "ACC V94-V102       6V103"
   V4404 = "ANN TOT TRANS H& W  6V104"
   V4405 = "ANN WRK HRS OTHERSH31H32"
   V4406 = "ANN TXBLE INC OTH H28H38"
   V4407 = "ACC ANN TXBL Y OTR 6V107"
   V4408 = "BKT OTH ASSET Y    6V108"
   V4409 = "TOT 75 TAXES OTHRS 6V109"
   V4410 = "ADC AFDC Y OTHERS H28H38"
   V4411 = "OTH WELFARE Y OTH H28H38"
   V4412 = "SOC SECURITY Y OT H28H38"
   V4413 = "RETIR Y OTHERS    H28H38"
   V4414 = "UNEMP Y OTHERS    H28H38"
   V4415 = "ALIMONY Y OTHERS  H28H38"
   V4416 = "SSI Y OTHERS      H28H38"
   V4417 = "HELP FRM RELA OTR H28H38"
   V4418 = "ANYTHING ELSE OTR H28H38"
   V4419 = "TOT TRANS Y OTHERS 6V119"
   V4420 = "ACC TOT TRANSY OTR 6V120"
   V4421 = "# INC REC OTR H& W  6V121"
   V4422 = "# LAB INC OTR H& W  6V122"
   V4423 = "1968 ID NUMBER     6V123"
   V4424 = "1969 ID NUMBER     6V124"
   V4425 = "1970 ID NUMBER     6V125"
   V4426 = "1971 ID NUMBER     6V126"
   V4427 = "1972 ID NUMBER     6V127"
   V4428 = "1973 ID NUMBER     6V128"
   V4429 = "1974 ID NUMBER     6V129"
   V4430 = "1975 ID NUMBER     6V130"
   V4431 = "IWER SOC SEC #     6V131"
   V4432 = "IWER INT NUMBER    6V132"
   V4433 = "DATE OF INTERVIEW  6V133"
   V4434 = "LENGTH OF INT      6V134"
   V4435 = "NUMBER IN FU       6V135"
   V4436 = "AGE OF HEAD        6V136"
   V4437 = "SEX OF HEAD        6V137"
   V4438 = "AGE OF WIFE        6V138"
   V4439 = "# OF CHILDREN FU   6V139"
   V4440 = "AGE YOUNGEST CHILD 6V140"
   V4441 = "CHILD <25 FU IN 75-76 A1"
   V4442 = "CHILD STOP SCHOOL     A2"
   V4443 = "PUB TRANS WALK DIST   B1"
   V4444 = "GOOD ENUF GET TO WRK  B2"
   V4445 = "OWN CAR OR TRUCK ?    B3"
   V4446 = "# CARS OR TRUCKS      B4"
   V4447 = "MILES DRIVEN LAST YEARB5"
   V4448 = "# OF RMS FOR YOUR FAM C1"
   V4449 = "TYPE OF DV            C2"
   V4450 = "OWN/RENT/OR WHAT      C3"
   V4451 = "WHY NOT OWN/RENT     C15"
   V4452 = "MOVED SINCE SPRNG 75 C17"
   V4453 = "WHAT MONTH WAS THAT  C18"
   V4454 = "WHY DID YOU MOVE     C19"
   V4455 = "MIGH MOVE NEXT 2 YRS C20"
   V4456 = "DEF MOVE/PROB MOVE   C21"
   V4457 = "WHY MIGHT YOU MOVE   C22"
   V4458 = "HD EMPLOYMENT STATUS  D1"
   V4459 = "HEAD OCCUPATION       D2"
   V4460 = "HEAD INDUSTRY         D4"
   V4461 = "WRK SOMEONEELSE/SELF  D5"
   V4462 = "FED STATE OR LOC GOV  D6"
   V4463 = "SUPERVISE OTHERS      D7"
   V4464 = "# PEOPLE SUPERVISE    D8"
   V4465 = "SAY THEIR PAY/PROMO   D9"
   V4466 = "BOSS HAS BOSS        D10"
   V4467 = "WRK OTR FED STA LOC  D11"
   V4468 = "SUPERVISE OTHERS     D12"
   V4469 = "# PEOPLE SUPERVISE   D13"
   V4470 = "SAY THEIR PAY/PROMO  D14"
   V4471 = "BOSS HAS BOSS        D15"
   V4472 = "BUSINESS INCORPORATEDD16"
   V4473 = "EMPLOY OTHER PEOPLE  D17"
   V4474 = "# EMPLOYED           D18"
   V4475 = "BUSINESS INCORPORATEDD19"
   V4476 = "EMPLOY OTHER PEOPLE  D20"
   V4477 = "HOW MANY             D21"
   V4478 = "JOB COV BY UNION CON D22"
   V4479 = "BELONG TO THAT UNION D23"
   V4480 = "HOW LONG PRES EMPLYR D24"
   V4481 = "FORM ED REQ JOB LIKE D25"
   V4482 = "WRK EXP SPEC TRAIN   D26"
   V4483 = "KIND EXP SPEC TRAIN  D27"
   V4484 = "HOW LONG FULLY TRAIN D28"
   V4485 = "LEARN FOR BETTER JOB D29"
   V4486 = "SKILLS CANT USE NOW  D30"
   V4487 = "WANT JOB USE THAT SK D31"
   V4488 = "HOW LONG PRES POSIT  D32"
   V4489 = "WHAT MO START JOB    D33"
   V4490 = "WHAT HAP JOB BEFORE  D34"
   V4491 = "PRES JOB BETTER/WORSED35"
   V4492 = "WHY IS IT (B/W)      D36"
   V4493 = "PRES JOB PAY MORE    D37"
   V4494 = "MISS WORK OTR ILL    D38"
   V4495 = "WAS THAT WIFE/CHILD  D39"
   V4496 = "WEEKS OF WRK MISSED  D40"
   V4497 = "MISS WRK SELF ILL    D41"
   V4498 = "WEEKS OF WRK MISSED  D42"
   V4499 = "WKS PAID VAC EACH YR D43"
   V4500 = "TAKE ANY VAC DUR 75  D44"
   V4501 = "# WEEKS VACATION USE D45"
   V4502 = "ON STRIKE IN 75      D46"
   V4503 = "# WEEKS ON STRIKE    D47"
   V4504 = "UNEMPL OR LAID OFF 75D48"
   V4505 = "# WEEKS UNEMPL       D49"
   V4506 = "UNEMPL 1 STRETCH     D50"
   V4507 = "# WEEKS WRKD MAINJOB D51"
   V4508 = "HRS/WEEK  MAIN JOB   D52"
   V4509 = "HOW PAID MAIN JOB    D55"
   V4510 = "$ /HOUR  SALARY       D56"
   V4511 = "PAID FOR OVERTIME    D57"
   V4512 = "$ /HOUR OVERTIME      D58"
   V4513 = "$ /HOUR HOURLY PAY    D59"
   V4514 = "$ /HOUR OVERTIME      D60"
   V4515 = "HOW PAID(NOTSAL/HRLY)D61"
   V4516 = "$ /HOUR OVERTIME      D62"
   V4517 = "# RETIREMENT PLANS   D63"
   V4518 = "SECOND JOB IN 75     D64"
   V4519 = "OCC SECOND JOB       D65"
   V4520 = "# OF EXTRA JOBS   D64D66"
   V4521 = "$ /HOUR 2ND JOB       D67"
   V4522 = "# WKS WRKED 2ND JOB  D68"
   V4523 = "HRS/WK ON 2ND JOB    D69"
   V4524 = "MORE WORK AVAILABLE  D70"
   V4525 = "$ /HOUR FOR MORE WORK D71"
   V4526 = "WHY NOT WORK EXTRA   D72"
   V4527 = "WORK MORE IF COULD   D73"
   V4528 = "WORK LESS IF WANTED  D74"
   V4529 = "PREF TO WORK LESS    D75"
   V4530 = "# MILES TO WORK      D77"
   V4531 = "HOW GET TO WORK      D78"
   V4532 = "FIND NEW JOB AS GOOD D79"
   V4533 = "PLAN TO QUIT         D80"
   V4534 = "WHY MIGHT QUIT       D81"
   V4535 = "GO BACK TO WORK LATERD82"
   V4536 = "WHEN MIGHT GO BACK   D83"
   V4537 = "BETTER JOB IF MOVE   D84"
   V4538 = "BETTER JOB FAR/DIFHRSD85"
   V4539 = "LIMITS CHOICE JOBNOW D86"
   V4540 = "WHAT LIMITS          D87"
   V4541 = "QUIT IF LOTSA $       D88"
   V4542 = "OCC LOOKING FOR       E1"
   V4543 = "GOOD JOB SAME LINE    E2"
   V4544 = "$ /HOUR EXPECT         E3"
   V4545 = "GET TRAIN TO QUALIFY  E4"
   V4546 = "LOOK FOR JOB LAST4WKS E5"
   V4547 = "# PLACES LOOKED       E6"
   V4548 = "LIMIT WHERE OR # HOURSE7"
   V4549 = "WHAT LIMITS           E8"
   V4550 = "JOBS IF MOVE          E9"
   V4551 = "HOW LONG LOOKING     E10"
   V4552 = "EVER HAD A JOB       E11"
   V4553 = "OCC LAST JOB         E12"
   V4554 = "IND LAST JOB         E13"
   V4555 = "SUPERVISE OTHERS     E14"
   V4556 = "HOW LOST THAT JOB    E15"
   V4557 = "YEAR LAST WORKED     E16"
   V4558 = "VACATION IN 1975     E17"
   V4559 = "# WKS VACATION       E18"
   V4560 = "MISS WORK OTHERS ILL E19"
   V4561 = "WAS THAT WIFE/CHILD  E20"
   V4562 = "# WEEKS MISSED WORK  E21"
   V4563 = "MISS WORK SELF ILL   E22"
   V4564 = "# WEEKS MISSED WORK  E23"
   V4565 = "ON STRIKE IN 1975    E24"
   V4566 = "# WEEKS ON STRIKE    E25"
   V4567 = "UNEMPL/LAID OFF 1975 E26"
   V4568 = "# WEEKS UNEMPL 1975  E27"
   V4569 = "UNEMPL 1 STRETCH     E28"
   V4570 = "#WKS WORKED MAINJOB  E29"
   V4571 = "HRS/WK MAIN JOB      E30"
   V4572 = "# MILES TO WORK      E32"
   V4573 = "HOW GET TO WORK      E33"
   V4574 = "QUIT IF LOTSA $       E34"
   V4575 = "HD WORK FOR $  IN 1975 F1"
   V4576 = "GET JOB IN FUTURE     F2"
   V4577 = "WHEN MIGHT GET JOB    F3"
   V4578 = "OCC WHEN WRKED        F4"
   V4579 = "IND WHEN WRKED        F5"
   V4580 = "# WKS WORKED IN 1975  F6"
   V4581 = "HRS/WK WORKED IN 75   F7"
   V4582 = "# MILES TO WORK       F9"
   V4583 = "HOW GET TO WORK      F10"
   V4584 = "HOW LOST THAT JOB F11F12"
   V4585 = "GET JOB FUTURE       F13"
   V4586 = "WHEN MIGHT GET JOB   F14"
   V4587 = "THINK ABOUT FUT JOB  F15"
   V4588 = "LIMIT HRS PLACE      F16"
   V4589 = "WHAT LIMITS          F17"
   V4590 = "KIND JOB HAVE IN MINDF18"
   V4591 = "EXPECTED HRLY $       F19"
   V4592 = "CHANCES GET GOOD JOB F20"
   V4593 = "TRAIN TO QUALIFY     F21"
   V4594 = "HOW GET THAT TRAIN   F22"
   V4595 = "GETTING TRAIN NOW    F23"
   V4596 = "DO LST 4 WKS FIND JOBF28"
   V4597 = "# PLACES LOOKED      F29"
   V4598 = "JOBS IF MOVE         F30"
   V4599 = "WOULD TAKE JOB       F24"
   V4600 = "WHY TAKE JOB         F25"
   V4601 = "LIMIT PLACE/HOURS    F26"
   V4602 = "WHAT LIMITS          F27"
   V4603 = "MARITAL STATUS        G1"
   V4604 = "DID WIFE WRK FOR $  75 G2"
   V4605 = "OCC WIFE              G3"
   V4606 = "IND WIFE              G4"
   V4607 = "# WEEKS WORKED WIFE   G5"
   V4608 = "# HRS/WK  WIFE        G6"
   V4609 = "HSEWRK HRS/WK HEAD    G7"
   V4610 = "OTRS DO HSEWRK        G9"
   V4611 = "BKT FARM INCOME 75    H2"
   V4612 = "OWN BUS IN 1975       H5"
   V4613 = "CORP OR UNINCORP      H6"
   V4614 = "INCOME FROM SOC SEC  H17"
   V4615 = "SOC SEC INCL SSI     H18"
   V4616 = "HELP WITH MED BILLS  H20"
   V4617 = "$  MEDICAL HELP 75    H21"
   V4618 = "LUMP SUM PYMTS 75    H41"
   V4619 = "BKT LUMP PYMTS 75    H42"
   V4620 = "HELP SUP ANYONE      H43"
   V4621 = "# HELP SUPPORT       H44"
   V4622 = "SUPP MORE THAN HALF  H45"
   V4623 = "HOW MANY SUPPORT     H47"
   V4624 = "BELONG TO LABOR UNIONH48"
   V4625 = "PHYS OR NERV COND HD H49"
   V4626 = "HOW LIMIT WRK HD     H50"
   V4627 = "REQUIRE EXTR CARE    H51"
   V4628 = "WHO IS THAT (REL H)  H52"
   V4629 = "WHO IS THAT (AGE)    H52"
   V4630 = "# YRS WRK SINCE 18 HD J1"
   V4631 = "# YRS WRK FULL TIME HDJ2"
   V4632 = "NOT WRK FULL TIME HD  J3"
   V4633 = "ACC COLS NOT FT HD 6V333"
   V4634 = "STOP WRK YR OR MORE   J4"
   V4635 = "1 PERIOD OR SEVERAL   J5"
   V4636 = "MONTH STOPPED WORK    J6"
   V4637 = "YEAR STOPPED WORK     J6"
   V4638 = "MONTH STARTED AGAIN   J6"
   V4639 = "YEAR STARTED AGAIN    J6"
   V4640 = "MOST REC MO STPD WORK J7"
   V4641 = "MOST REC YR STPD WORK J7"
   V4642 = "MOST REC MO BEG AGAIN J7"
   V4643 = "MOST REC YR BEG AGAIN J7"
   V4644 = "WHY STOP WRK 1ST MENT J8"
   V4645 = "WHY STOP WRK 2ND MENT J8"
   V4646_1 = "WHY STOP WRK TWO MENT J8 RESP 1"
   V4646_2 = "WHY STOP WRK TWO MENT J8 RESP 2"
   V4647 = "TRAIN WHILE NOT WRK   J9"
   V4648 = "WHY GO BACK 1ST MENT J10"
   V4649 = "WHY GO BACK 2ND MENT J10"
   V4650_1 = "WHY GO BACK TWO MENT J10 RESP 1"
   V4650_2 = "WHY GO BACK TWO MENT J10 RESP 2"
   V4651 = "SAME WORK AS BEFORE  J11"
   V4652 = "WAS IT THE SAME JOB  J12"
   V4653 = "HOW FIND JOB         J13"
   V4654 = "HOW GET SKIL TO QUAL J14"
   V4655 = "$ /HR WHEN WENT BACK  J15"
   V4656 = "$ /HR IF NEVER QUIT   J16"
   V4657 = "WHY $ /HR SAME OR DIFFJ17"
   V4658 = "NEW HEAD THIS YR      K1"
   V4659 = "FATHERS STATE         K2"
   V4660 = "FATHERS COUNTY        K2"
   V4661 = "MOTHERS STATE         K2"
   V4662 = "MOTHERS COUNTY        K2"
   V4663 = "FATHERS OCCUPATION    K3"
   V4664 = "FIRST REGULAR JOB HD  K4"
   V4665 = "SAME OCC ALWAYS HD    K5"
   V4666 = "AGE OLDEST CHLD HDK6-K10"
   V4667 = "AGE 2ND OLDEST HD K6-K10"
   V4668 = "AGE 3RD OLDEST HD K6-K10"
   V4669 = "TOT # CHILD OF HD K6-K10"
   V4670 = "# CHILD BY 25 HD  K6-K10"
   V4671 = "# SIBLINGS OF HEAD   K11"
   V4672 = "ANY SIBS OLDER       K12"
   V4673 = "SIZE PLAC HEAD GREWUPK13"
   V4674 = "STATE HD GREW UP  K14K15"
   V4675 = "CNTY HD GREW UP   K14K15"
   V4676 = "#REGIONS HD K14-16(M4M6)"
   V4677 = "#STATES HD  K14-16(M4M6)"
   V4678 = "EVER MOVED FOR JOB   K17"
   V4679 = "TURN DOWN JOB        K18"
   V4680 = "PARENTS POOR OR WHAT K19"
   V4681 = "EDUC HD FATHER   K20-K21"
   V4682 = "EDUC HD MOTHER   K22-K23"
   V4683 = "HEAD VETERAN         K24"
   V4684 = "# YRS HD SCHOOLING   K25"
   V4685 = "ANY OTHER TRAINING   K26"
   V4686 = "HDS OTHER TRAINING   K27"
   V4687 = "TROUBLE READING HD   K28"
   V4688 = "ANY OTR SCHOOLING HD K29"
   V4689 = "WHAT OTR SCH HD      K30"
   V4690 = "COLLEGE DEGREE HEAD  K32"
   V4691 = "ADVANCED DEGREES HEADK33"
   V4692 = "RECORD REL PREF      K34"
   V4693 = "RELIGIOUS PREF HD K35K36"
   V4694 = "NEW WIFE THIS YR      L1"
   V4695 = "# YRS WIFE IN SCHOOL  L2"
   V4696 = "WIFE OTR SCHOOLING    L3"
   V4697 = "WHAT OTR SCH WIFE     L4"
   V4698 = "COLLEGE DEGREE WIFE   L6"
   V4699 = "ADVANCED DEGREES WIFE L7"
   V4700 = "WHO WAS RESPONDENT    M1"
   V4701 = "NUMBER OF CALLS       M2"
   V4702 = "LIVE IN CITY 50,000   M3"
   V4703 = "NAME CITY 50,000      M4"
   V4704 = "# MILES TO CENTER CITYM5"
   V4705 = "NAME NEAR CITY 50,000 M6"
   V4706 = "# MILES TO CENTER CITYM7"
   V4707 = "LIVE IN CITY 5,000    M8"
   V4708 = "1976 ID NUMBER-WF"
   V4709 = "TELEPHONE INT?-WF"
   V4710 = "HEAD/WIFE MATCH #"
   V4711 = "ANN HRS HSWRK-WIFE    B1"
   V4712 = "ACC ANN HRS HSWRK-WF"
   V4713 = "ANN COST OF HSWRK OUT B3"
   V4714 = "ANN HRS CHLCARE-WF    B6"
   V4715 = "ANN HRS CH CARE-HEAD  B8"
   V4716 = "ANN HR CH CARE-WF WRKB12"
   V4717 = "ANN COST CH CARE B14,B15"
   V4718 = "ANN HR CHCARE-O  B16,B17"
   V4719 = "ANN WORK HRS-WIFE"
   V4720 = "ACC ANN WRK HRS-WF"
   V4721 = "ANN ILL HRS-OTR  D40,E22"
   V4722 = "ACC ANN ILL HR OTR"
   V4723 = "ANN ILL HRS-WF   D42,E24"
   V4724 = "ACC ANN ILL HR-WF"
   V4725 = "ANN STRIKE HOURS D47,E26"
   V4726 = "ACC ANN STRIKE HRS"
   V4727 = "ANN UNEMP HRS-WF  D49E28"
   V4728 = "ACC ANN UNEMP HRS-WF"
   V4729 = "ANN HR TRAVEL TO WRK-WF"
   V4730 = "ACC HR TRAV WK-WF"
   V4731 = "1968 ID-WIFE"
   V4732 = "1969 ID-WIFE"
   V4733 = "1970 ID-WIFE"
   V4734 = "1971 ID-WIFE"
   V4735 = "1972 ID-WIFE"
   V4736 = "1973 ID-WIFE"
   V4737 = "1974 ID-WIFE"
   V4738 = "1975 ID-WIFE"
   V4739 = "INT SOC SEC-WIFE"
   V4740 = "IWERS INT #-WIFE"
   V4741 = "DATE OF WF INT"
   V4742 = "LENGTH OF WF INT"
   V4743 = "AGE OF WIFE"
   V4744 = "STATE GREW UP-WF DAD  A1"
   V4745 = "STATE GREW UP-WF MOM  A1"
   V4746 = "OCCUPATION-WFS DAD    A2"
   V4747 = "OCCUPATION-WFS MOM    A3"
   V4748 = "# SIBLINGS-WF         A4"
   V4749 = "WTR OLDER SIBLINGS-WF A5"
   V4750 = "GREW UP FARM?-WF      A6"
   V4751 = "STATE GREW UP-WF   A7,A8"
   V4752 = "COUNTY GREW UP-WF  A7,A8"
   V4753 = "EDUCATION-WF DAD  A9,A10"
   V4754 = "EDUCATION-WF MOM A11,A12"
   V4755 = "EDUCATION-WF         A13"
   V4756 = "OTR TRNG? IF<7 GR-WF A14"
   V4757 = "TYPE TRNG IF<7 GR-WF A15"
   V4758 = "PROBS READ?IF<7 G-WF A16"
   V4759 = "OTR SCHLNG?7-12GR-WF A17"
   V4760 = "TYPE SCHLNG 7-12G-WF A18"
   V4761 = "COLLEGE DEG?>12GR-WF A19"
   V4762 = "ADV DEG?>12GR- WF    A20"
   V4763 = "YEAR 1ST MARR-WF     A21"
   V4764 = "REL PREF ALLOWED?-WF A22"
   V4765 = "RELIG PREF-WF    A23,A24"
   V4766 = "WTR DISABILITY-WF    A25"
   V4767 = "DISAB LIMIT WRK?-WF  A26"
   V4768 = "HR/WK HSWRK-WF        B1"
   V4769 = "PAY OUTSIDE HSWRK?-WF B2"
   V4770 = "$ /WK PD HSWK-WF       B3"
   V4771 = "KIDS<12 IN FU?        B4"
   V4772 = "XTRA HRS CH CARE?-WF  B5"
   V4773 = "HR/WK XTRA CH CARE-WF B6"
   V4774 = "HUSB DO CH CARE?-WF   B7"
   V4775 = "HR/WK HUSB CH CARE-WF B8"
   V4776 = "NOW EMPLOYED?-WF      B9"
   V4777 = "MODE CH CARE-1ST B10,B11"
   V4778 = "MODE CH CARE-2ND B10,B11"
   V4779_1 = "DOUBLE MENT CHCREB10,B11 RESP 1"
   V4779_2 = "DOUBLE MENT CHCREB10,B11 RESP 2"
   V4780 = "HR/WK CH CARE OUT-WF B12"
   V4781 = "PAY OR?-CH CARE OUT  B13"
   V4782 = "$ /WK CH CARE OUT-PD  B14"
   V4783 = "$ /WK CH CARE OUT-P&   B15"
   V4784 = "HR/WK CH CARE OUT-P&  B16"
   V4785 = "HR/WK CH CARE OUT-DO B17"
   V4786 = "# CH CARE BREAKDOWNS B18"
   V4787 = "WHO STAYD HOME?-WF   B19"
   V4788 = "CLD ARRANGE CH CARE? B20"
   V4789 = "TYPE CH CARE ARR?    B21"
   V4790 = "$ /HR CH CARE IF WRK  B22"
   V4791 = "WRK CAUSE PROBS?-WF  B23"
   V4792 = "TYPE PROBS IF WF WRK B24"
   V4793 = "WHY PROBS IF WF WRK? B25"
   V4794 = "$ /HR CH CARE         B26"
   V4795 = "EVER RAISED KIDS?     C1"
   V4796 = "AGE OLDEST CHLD-WF C2-C4"
   V4797 = "AGE 2ND OLDEST CHLDC2-C4"
   V4798 = "AGE 3RD OLDEST CHLDC2-C4"
   V4799 = "TOTAL # CHILDREN-WFC2-C4"
   V4800 = "# B4 25-WF         C2-C4"
   V4801 = "# CHILDREN RAISED     C2"
   V4802 = "MO YOUNGEST CH BORN   C3"
   V4803 = "YR YOUNGEST CH BORN   C3"
   V4804 = "MO 2ND YNGST CH BORN  C3"
   V4805 = "YR 2ND YNGST CH BORN  C3"
   V4806 = "MO 3RD YNGST CH BORN  C3"
   V4807 = "YR 3RD YNGST CH BORN  C3"
   V4808 = "MO 4TH YNGST CH BORN  C3"
   V4809 = "YR 4TH YNGST CH BORN  C3"
   V4810 = "MO 5TH YNGST CH BORN  C3"
   V4811 = "YR 5TH YNGST CH BORN  C3"
   V4812 = "MO 6TH YNGST CH BORN  C3"
   V4813 = "YR 6TH YNGST CH BORN  C3"
   V4814 = "MO 7TH YNGST CH BORN  C3"
   V4815 = "YR 7TH YNGST CH BORN  C3"
   V4816 = "MO OLDEST CH BORN     C3"
   V4817 = "YR OLDEST CH BORN     C3"
   V4818 = "ANY NOT BORN TO WIFE? C4"
   V4819 = "WF EMPL ERE MARRIAGE? C5"
   V4820 = "FULL TIME OR?         C6"
   V4821 = "WF EMPL 1ST YRS MARR? C7"
   V4822 = "FULL TIME OR?         C8"
   V4823 = "WF EMPL PRESCHLRS?    C9"
   V4824 = "FULL TIME OR?        C10"
   V4825 = "WF EMPL ERE MARRIAGE?C11"
   V4826 = "FULL TIME OR?        C12"
   V4827 = "WF EMPL 1ST YRS MARR?C13"
   V4828 = "FULL TIME OR?        C14"
   V4829 = "WIFE >50 ?           C15"
   V4830 = "EXPECT MORE KIDS?    C16"
   V4831 = "TOT # KIDS EXPECT    C17"
   V4832 = "# YRS TIL LAST CH BRNC18"
   V4833 = "TYPE FUTURE JOB PLANSC19"
   V4834 = "HOW SURE NO MORE KIDSC20"
   V4835 = "HUSB WANT MORE KIDS? C21"
   V4836 = "HUSB WANT WF TO WRK? C22"
   V4837 = "KIDS<12/EXPECT KIDS? C23"
   V4838 = "MOST EDUC EXPECT KIDSC24"
   V4839 = "LEAST EDUC EXPCT KIDSC24"
   V4840_1 = "EDUC EXPT KIDS-DOUBLE RESP 1"
   V4840_2 = "EDUC EXPT KIDS-DOUBLE RESP 2"
   V4841 = "EMPLOYMENT STATUS-WF  D1"
   V4842 = "OCCUPATION(E)-WF      D2"
   V4843 = "INDUSTRY(E)-WF        D4"
   V4844 = "WRK FOR SELF OR?(E)-WFD5"
   V4845 = "WRK FOR GOVT?(E)-WF   D6"
   V4846 = "SUPERVISE OTRS?(E)-WF D7"
   V4847 = "# SUPERVISED(E)-WF    D8"
   V4848 = "SAY OVER PAY/PROMO?(E)D9"
   V4849 = "BOSS HAS BOSS?(E)-WF D10"
   V4850 = "WRK FOR GOVT?(E)-WF  D11"
   V4851 = "SUPERVISE OTRS?(E)-WFD12"
   V4852 = "# SUPERVISED(E)-WF   D13"
   V4853 = "SAY OVER PAY/PROMO?E D14"
   V4854 = "BOSS HAS BOSS?(E)    D15"
   V4855 = "OWN BUSINESS INC?(E) D16"
   V4856 = "EMPL OTHERS?(E)-WIFE D17"
   V4857 = "# EMPL BY WF(E)-WF   D18"
   V4858 = "BUSINESS INC?(E)-WF  D19"
   V4859 = "EMPL OTRS?(E)-WIFE   D20"
   V4860 = "# EMPL BY WF(E)      D21"
   V4861 = "JOB COVERD BY UNION? D22"
   V4862 = "WF BELONG THAT UNION?D23"
   V4863 = "# MOS WKD-THIS EMPLR D24"
   V4864 = "EDUC REQ THIS JOB(E) D25"
   V4865 = "NEED SPEC TRNG?(E)-W D26"
   V4866 = "TYPE TRNG NEEDED(E)  D27"
   V4867 = "#MOS TO FULLY QUALIFYD28"
   V4868 = "LEARN ON THIS JOB?(E)D29"
   V4869 = "SKILLS CANT USE? (E) D30"
   V4870 = "GET JOB USING SKILLS?D31"
   V4871 = "# MOS THIS POSITION  D32"
   V4872 = "MO BEGAN THIS JOB (E)D33"
   V4873 = "WHAT HAPPENED JOB(E) D34"
   V4874 = "THIS JOB BETTER? (E) D35"
   V4875 = "WHY JOB BETTER(E)-WF D36"
   V4876 = "THIS JOB PAY MORE?(E)D37"
   V4877 = "WTR OTRS ILL(E)-WIFE D38"
   V4878 = "WHO ILL? (E)-WF      D39"
   V4879 = "#WKS OTRS ILL(E)-WF  D40"
   V4880 = "WTR ILL SELF (E)-WF  D41"
   V4881 = "# WKS WF ILL (E)     D42"
   V4882 = "# WKS PD VACATION    D43"
   V4883 = "WTR TOOK VACATION(E) D44"
   V4884 = "# WKS VACATION(E)-WF D45"
   V4885 = "WTR ON STRIKE(E)-WF  D46"
   V4886 = "# WKS ON STRIKE(E)-W D47"
   V4887 = "WTR LAYOFF(E)-WF     D48"
   V4888 = "# WKS LAYOFF(E)-WF   D49"
   V4889 = "LAYOFF/UNEMP ONCE OR?D50"
   V4890 = "# WKS WKD MAIN JOB(E)D51"
   V4891 = "HR/WK WKD MAIN JOB(E)D52"
   V4892 = "SALARY/HRLY OR?(E)-WFD55"
   V4893 = "PAY/HR-SALARIED (E)  D56"
   V4894 = "PD FOR OVERTIME?(E)  D57"
   V4895 = "PAY/HR OVERTIME-SAL  D58"
   V4896 = "HRLY WAGE-HRLY EMPL  D59"
   V4897 = "HRLY WAGE-OT HRLY EMPD60"
   V4898 = "WHY NOT SAL/HRLY?-WF D61"
   V4899 = "PAY/HR NONSAL/HRLY-W D62"
   V4900 = "# PENSION PLANS(E)-W D63"
   V4901 = "WTR XTRA JOB(E)-WF   D64"
   V4902 = "OCC-XTRA JOB-WF      D65"
   V4903 = "TOTAL # XTRA JOBS-WF D66"
   V4904 = "PAY/HR ON XTRA JOB-WFD67"
   V4905 = "WKS WKD ON XTRA JOB  D68"
   V4906 = "HR/WK WKD-XTRA JOB(E)D69"
   V4907 = "MORE WK AVAILABLE?(E)D70"
   V4908 = "PAY/HR FOR XTRA WRK  D71"
   V4909 = "WHY DIDNT WORK MORE  D72"
   V4910 = "LIKE WRK MORE?(E)-WF D73"
   V4911 = "CLD WRK LESS?(E)-WF  D74"
   V4912 = "LIKE WRK LESS?(E)    D75"
   V4913 = "# MILES TO WORK(E)-W D77"
   V4914 = "MODE TRVL TO WRK(E)  D78"
   V4915 = "CLD FIND AS GOOD JOB?D79"
   V4916 = "KEEP ON OR QUIT?(E)  D80"
   V4917 = "WHY MIGHT QUIT(E)-WF D81"
   V4918 = "GO BACK LATER?(E)-WF D82"
   V4919 = "WHEN GO BACK(E)-WF   D83"
   V4920 = "GET JOB IF MOVE?(E)  D84"
   V4921 = "GET JOB IF DIFF HRS? D85"
   V4922 = "LIMITS ON THIS JOB?  D86"
   V4923 = "WHAT LIMITS?(E)-WF   D87"
   V4924 = "IF $ ,WOULD WRK?(E)-WFD88"
   V4925 = "OCC SOUGHT(U)-WIFE    E1"
   V4926 = "WHAT CHANCE FOR JOB?  E2"
   V4927 = "PAY/HR ON JOB SOUGHT  E3"
   V4928 = "NEED TRAINING?(U)-WF  E4"
   V4929 = "BELONG TO UNION?-WF   E5"
   V4930 = "WTR LOOK FOR JOB(U)-WFE6"
   V4931 = "# PLAC LOOK FOR JOB(U)E7"
   V4932 = "LIMITS ON LOC/HRS?(U) E8"
   V4933 = "WHAT LIMITS ON LOC/HR E9"
   V4934 = "GET JOB IF MOVE?(U)  E10"
   V4935 = "# WKS LOOK FOR WRK(U)E11"
   V4936 = "EVER HAD JOB?(U)     E12"
   V4937 = "OCC ON LAST JOB(U)-W E13"
   V4938 = "IND ON LAST JOB(U)-W E14"
   V4939 = "SUPERVISD OTRS?(U)   E15"
   V4940 = "WHAT HAPPENED JOB?(U)E16"
   V4941 = "YR LAST WORKED(U)-WF E17"
   V4942 = "WTR VACATION(U)-WF   E18"
   V4943 = "# WKS VACATION(U)    E19"
   V4944 = "WTR OTRS ILL(U)-WF   E20"
   V4945 = "WHO ILL?(U)-WIFE     E21"
   V4946 = "# WKS OTRS ILL(U)-WF E22"
   V4947 = "WTR SELF ILL(U)-WIFE E23"
   V4948 = "# WKS SELF ILL(U)-WF E24"
   V4949 = "WTR ON STRIKE(U)-WF  E25"
   V4950 = "# WKS ON STRIKE(U)-W E26"
   V4951 = "WTR LAID OFF(U)-WIFE E27"
   V4952 = "# WKS ON LAYOFF(U)-WFE28"
   V4953 = "LAYOFF/UNEMP ONCE OR?E29"
   V4954 = "WKS WKD(U)-WIFE      E30"
   V4955 = "HR/WK WKD(U)-WIFE    E31"
   V4956 = "# MI TRVL TO WRK(U)  E33"
   V4957 = "MODE TRVL TO WRK(U)  E34"
   V4958 = "IF $ , WOULD WORK?(U) E35"
   V4959 = "WRK FOR $  IN 75?(R)-W F1"
   V4960 = "THINK GET JOB?(R)-WF  F2"
   V4961 = "WHEN GET JOB(R)-WIFE  F3"
   V4962 = "OCCUPATION(R)-WIFE    F4"
   V4963 = "INDUSTRY(R)-WIFE      F5"
   V4964 = "# WKS WKD(R)-WIFE     F6"
   V4965 = "HR/WK WKD(R)-WIFE     F7"
   V4966 = "# MI TO WORK(R)-WIFE  F8"
   V4967 = "MODE TRVL TO WK(R)-WF F9"
   V4968 = "WHY NOT WRK NOW  F11,F12"
   V4969 = "THINK GET JOB?(R)-WF F13"
   V4970 = "WHEN MIGHT GET JOB(R)F14"
   V4971 = "GET/NOT GET JOB(R)-W F15"
   V4972 = "LIMIT LOC/HRS?(R)-WF F16"
   V4973 = "WHAT LIMITS?(R)-WF   F17"
   V4974 = "TYPE JOB MIGHT GET(R)F18"
   V4975 = "DAY/HR JOB MIGHT GET F19"
   V4976 = "GOOD/BAD CHANCE JOB  F20"
   V4977 = "NEED TRAINING?(R)-WF F21"
   V4978 = "HOW GET TRNG?(R)-WF  F22"
   V4979 = "GET TRNG NOW?(R)-WF  F23"
   V4980 = "IF JOB, HELP W/HSWK? F28"
   V4981 = "PAY FOR HSWK HELP?(R)F29"
   V4982 = "LOOKED FOR JOB?(R)-W F30"
   V4983 = "# PLAC LOOK FOR JOB  F31"
   V4984 = "GET JOB IF MOVE?(R)  F32"
   V4985 = "POSS GET JOB?(R)     F24"
   V4986 = "WHY POSSIBLE GET JOB?F25"
   V4987 = "LIMIT ON LOC/HRS?-WF F26"
   V4988 = "WHAT LIMITS?(R)-WIFE F27"
   V4989 = "# YRS WKD SINCE 18-WF G1"
   V4990 = "# YRS WKD FULL TIME-W G2"
   V4991 = "PCTG TIME WKD-WIFE    G3"
   V4992 = "ACC PCTG TIME WKD-WF  G3"
   V4993 = "OCCUPATION-1ST JOB-WF G4"
   V4994 = "# DIFF JOBS OR?-WF    G5"
   V4995 = "INTERRUPT WRK EXP?-WF G6"
   V4996 = "INTRPT WK ONCE OR?-WF G7"
   V4997 = "MO STOPPED WORK-WF    G8"
   V4998 = "YR STOPPED WORK-WF    G8"
   V4999 = "MO RESTARTED WORK-WF  G8"
   V5000 = "YR RESTARTED WORK-WF  G8"
   V5001 = "MO STOPD WRK-LAST-WF  G9"
   V5002 = "YR STOPD WRK-LAST-WF  G9"
   V5003 = "MO RESTARTD WRK-LAST  G9"
   V5004 = "YR RESTARTD WRK-LAST  G9"
   V5005 = "WHY STOPPED WRK?-1ST G10"
   V5006 = "WHY STOPPED WRK?-2ND G10"
   V5007_1 = "WHY STOPD WRK-DOUBLE G10 RESP 1"
   V5007_2 = "WHY STOPD WRK-DOUBLE G10 RESP 2"
   V5008 = "GOT TRNG CLD USE JOB?G11"
   V5009 = "WHY RETD WRK?1ST-WF  G12"
   V5010 = "WHY RETD WRK?2ND-WF  G12"
   V5011_1 = "WHY RETD WRK?DOUBLE-WG12 RESP 1"
   V5011_2 = "WHY RETD WRK?DOUBLE-WG12 RESP 2"
   V5012 = "RET SAME OCC?-WIFE   G13"
   V5013 = "SAME JOB?-WF         G14"
   V5014 = "HOW FOUND JOB-WIFE   G15"
   V5015 = "HOW GOT SKILLS-WIFE  G16"
   V5016 = "PAY/HR ON RETURN-WF  G17"
   V5017 = "PAY/HR IF NOT STOPD-WG18"
   V5018 = "WHY DIFF PAY/HR?-WF  G19"
   V5019 = "HUSB HELP HSWK AFTER?G20"
   V5020 = "SURE LIFE WORK OUT    H1"
   V5021 = "PLAN AHEAD OR?        H2"
   V5022 = "CARRY OUT PLANS       H3"
   V5023 = "FINISH THINGS OR?     H4"
   V5024 = "SPEND $  OR SAVE       H5"
   V5025 = "THINK ABOUT FUTURE    H6"
   V5026 = "RESPONDENT            J1"
   V5027 = "# CALLS               J2"
   V5028 = "HOUSE VALUE BKT    6V728"
   V5029 = "TOT FU MONEY INC   6V729"
   V5030 = "TOT FU MON INC BKT 6V730"
   V5031 = "HEAD TOTAL LABOR Y 6V731"
   V5032 = "HD TOT LABOR Y BKT 6V732"
   V5033 = "WF TOT LABOR Y BKT 6V733"
   V5034 = "TOT TAX Y H+W BKT  6V734"
   V5035 = "TOT TAX Y OTHR BKT 6V735"
   V5036 = "H+W ADC,AFDC BKT   6V736"
   V5037 = "H+W OTHER WELF BKT 6V737"
   V5038 = "H+W SOC SECUR BKT  6V738"
   V5039 = "HD OTHER RETIR BKT 6V739"
   V5040 = "HD UNEMPLOYMNT BKT 6V740"
   V5041 = "HD ALIMONY BKT     6V741"
   V5042 = "HD SUPP SECUR BKT  6V742"
   V5043 = "H+W TOT TRNS Y BKT 6V743"
   V5044 = "H+W MISC TRANSFERS 6V744"
   V5045 = "H+W MISC TRANS BKT 6V745"
   V5046 = "TOT TRNS Y-OTR BKT 6V746"
   V5047 = "TOT FU MON Y/NEEDS 6V747"
   V5048 = "MONEY Y/NEEDS BKT  6V748"
   V5049 = "ANNUAL FOOD STD    6V749"
   V5050 = "HD AVG HOURLY EARN 6V750"
   V5051 = "BKT HD AVG HR EARN 6V751"
   V5052 = "WIFE AVG HRLY EARN 6V752"
   V5053 = "BKT WF AVG HR EARN 6V753"
   V5054 = "CURRENT REGION     6V754"
   V5055 = "REGION HD GREW UP  6V755"
   V5056 = "REGION DAD GREW UP 6V756"
   V5057 = "REGION MOM GREW UP 6V757"
   V5058 = "GEOGRAPHIC MOBILITY6V758"
   V5059 = "ACCUR TOT FU MON Y 6V759"
   V5060 = "# MINOR ASSIGNMENT 6V760"
   V5061 = "# MAJOR ASSIGNMENT 6V761"
   V5062 = "VALUE PER ROOM     6V762"
   V5063 = "BKT VALUE PER ROOM 6V763"
   V5064 = "BKT HR WAGE OV-TIM 6V764"
   V5065 = "BKT REG HRLY WAGE  6V765"
   V5066 = "BKT HR WAGE 2ND JB 6V766"
   V5067 = "BKT ACTL-REQD ROOM 6V767"
   V5068 = "PERSONS PER ROOM   6V768"
   V5069 = "BKT PERSONS/ROOM   6V769"
   V5070 = "NUMBER OF ADULTS   6V770"
   V5071 = "ONE DIGIT FAM SIZE 6V771"
   V5072 = "BKT AGE OF HEAD    6V772"
   V5073 = "BKT AGE OF WIFE    6V773"
   V5074 = "HEAD EDUCATION BKT 6V774"
   V5075 = "WIFE EDUCATION BKT 6V775"
   V5076 = "LOW INC TAX CREDIT 6V776"
   V5077 = "DEC TOT FU INC     6V777"
   V5078 = "DECILE Y/NEEDS     6V778"
   V5079 = "# CHILDREN 1-2 YRS 6V779"
   V5080 = "# CHILDREN 3-5 YRS 6V780"
   V5081 = "# CHILDREN 6-13 YR 6V781"
   V5082 = "# FEM CHILDS 14-17 6V782"
   V5083 = "# MALE CHILD 14-17 6V783"
   V5084 = "# FEM CHILDS 18-20 6V784"
   V5085 = "# MALE CHILD 18-20 6V785"
   V5086 = "# FEM CHILDS 21-29 6V786"
   V5087 = "# MALE CHILD 21-29 6V787"
   V5088 = "AVG ACT HEAD COLL  6V788"
   V5089 = "EXPND/STUD HD COLL 6V789"
   V5090 = "PREWW2 RAT HD COLL 6V790"
   V5091 = "PSTWW2 RAT HD COLL 6V791"
   V5092 = "AVG ACT WIFE COLL  6V792"
   V5093 = "EXPND/STUD WF COLL 6V793"
   V5094 = "PREWW2 RAT WF COLL 6V794"
   V5095 = "PSTWW2 RAT WF COLL 6V795"
   V5096 = "RACE               6V796"
   V5097 = "SPLIT SAMPLE VAR   6V797"
   V5098 = "9YR FAM COMP CHNG  6V798"
   V5099 = "1976 FAMILY WEIGHT"
   V5100 = "REGION WF GREW UP  6V800"
   V5101 = "RGN WF DAD GREW UP 6V801"
   V5102 = "RGN WF MOM GREW UP 6V802"
   V5103 = "GEOG MOBILITY WF   6V803"
   V5104 = "BKT $ /HR OV-TIM WF 6V804"
   V5105 = "BKT REG HR WAGE WF 6V805"
   V5106 = "BKT $ /HR 2NDJOB WF 6V806"
   V5107 = "UNSKILLED MALE MKT 6V807"
   V5108 = "UNSKILLED F/M MKT  6V808"
   V5109 = "UNSKIL NONW/W MKT  6V809"
   V5110 = "UNSKILL MALE WAGE  6V810"
   V5111 = "DIFF UNSK M/F WAGE 6V811"
   V5112 = "COUNTY UNEMP RATE  6V812"
   V5113 = "HOUSEHOLD ID # 76"
   V5114 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V4303=99 THEN V4303=.;
IF V4304=999 THEN V4304=.;
IF V4305=99999 THEN V4305=.;
IF V4306=9 THEN V4306=.;
IF V4308=9 THEN V4308=.;
IF V4309=9 THEN V4309=.;
IF V4324=9 THEN V4324=.;
IF V4325=9999 THEN V4325=.;
IF V4328=9 THEN V4328=.;
IF V4329=9 THEN V4329=.;
IF V4361=9 THEN V4361=.;
IF V4366=9 THEN V4366=.;
IF V4367=99 THEN V4367=.;
IF V4388=99999 THEN V4388=.;
IF V4408=9 THEN V4408=.;
IF V4432=99 THEN V4432=.;
IF V4433=9 THEN V4433=.;
IF V4434=999 THEN V4434=.;
IF V4436=99 THEN V4436=.;
IF V4438=99 THEN V4438=.;
IF V4442=9 THEN V4442=.;
IF V4443=9 THEN V4443=.;
IF V4444=9 THEN V4444=.;
IF V4445=9 THEN V4445=.;
IF V4446=9 THEN V4446=.;
IF V4447=99999 THEN V4447=.;
IF V4448=9 THEN V4448=.;
IF V4449=9 THEN V4449=.;
IF V4451=9 THEN V4451=.;
IF V4452=9 THEN V4452=.;
IF V4453=99 THEN V4453=.;
IF V4454=9 THEN V4454=.;
IF V4455=9 THEN V4455=.;
IF V4456=9 THEN V4456=.;
IF V4457=9 THEN V4457=.;
IF V4459=99 THEN V4459=.;
IF V4460=99 THEN V4460=.;
IF V4461=9 THEN V4461=.;
IF V4462=9 THEN V4462=.;
IF V4463=9 THEN V4463=.;
IF V4464=99 THEN V4464=.;
IF V4465=9 THEN V4465=.;
IF V4466=9 THEN V4466=.;
IF V4467=9 THEN V4467=.;
IF V4468=9 THEN V4468=.;
IF V4469=99 THEN V4469=.;
IF V4470=9 THEN V4470=.;
IF V4471=9 THEN V4471=.;
IF V4472=9 THEN V4472=.;
IF V4473=9 THEN V4473=.;
IF V4474=99 THEN V4474=.;
IF V4475=9 THEN V4475=.;
IF V4476=9 THEN V4476=.;
IF V4477=99 THEN V4477=.;
IF V4478=9 THEN V4478=.;
IF V4479=9 THEN V4479=.;
IF V4480=999 THEN V4480=.;
IF V4481=9 THEN V4481=.;
IF V4482=9 THEN V4482=.;
IF V4483=9 THEN V4483=.;
IF V4484=99 THEN V4484=.;
IF V4485=9 THEN V4485=.;
IF V4486=9 THEN V4486=.;
IF V4487=9 THEN V4487=.;
IF V4488=99 THEN V4488=.;
IF V4489=99 THEN V4489=.;
IF V4490=9 THEN V4490=.;
IF V4491=9 THEN V4491=.;
IF V4492=9 THEN V4492=.;
IF V4493=9 THEN V4493=.;
IF V4494=9 THEN V4494=.;
IF V4495=9 THEN V4495=.;
IF V4496=99 THEN V4496=.;
IF V4497=9 THEN V4497=.;
IF V4498=99 THEN V4498=.;
IF V4499=99 THEN V4499=.;
IF V4500=9 THEN V4500=.;
IF V4501=99 THEN V4501=.;
IF V4502=9 THEN V4502=.;
IF V4503=99 THEN V4503=.;
IF V4504=9 THEN V4504=.;
IF V4505=99 THEN V4505=.;
IF V4506=9 THEN V4506=.;
IF V4507=99 THEN V4507=.;
IF V4508=99 THEN V4508=.;
IF V4509=9 THEN V4509=.;
IF V4510=999 THEN V4510=.;
IF V4511=9 THEN V4511=.;
IF V4512=999 THEN V4512=.;
IF V4513=999 THEN V4513=.;
IF V4514=999 THEN V4514=.;
IF V4515=9 THEN V4515=.;
IF V4516=999 THEN V4516=.;
IF V4517=9 THEN V4517=.;
IF V4518=9 THEN V4518=.;
IF V4519=99 THEN V4519=.;
IF V4520=9 THEN V4520=.;
IF V4521=999 THEN V4521=.;
IF V4522=99 THEN V4522=.;
IF V4523=99 THEN V4523=.;
IF V4524=9 THEN V4524=.;
IF V4525=999 THEN V4525=.;
IF V4526=9 THEN V4526=.;
IF V4527=9 THEN V4527=.;
IF V4528=9 THEN V4528=.;
IF V4529=9 THEN V4529=.;
IF V4530=99 THEN V4530=.;
IF V4531=9 THEN V4531=.;
IF V4532=9 THEN V4532=.;
IF V4533=9 THEN V4533=.;
IF V4534=9 THEN V4534=.;
IF V4535=9 THEN V4535=.;
IF V4536=99 THEN V4536=.;
IF V4537=9 THEN V4537=.;
IF V4538=9 THEN V4538=.;
IF V4539=9 THEN V4539=.;
IF V4540=9 THEN V4540=.;
IF V4541=9 THEN V4541=.;
IF V4542=99 THEN V4542=.;
IF V4543=9 THEN V4543=.;
IF V4544=999 THEN V4544=.;
IF V4545=9 THEN V4545=.;
IF V4546=9 THEN V4546=.;
IF V4547=9 THEN V4547=.;
IF V4548=9 THEN V4548=.;
IF V4549=9 THEN V4549=.;
IF V4550=9 THEN V4550=.;
IF V4551=99 THEN V4551=.;
IF V4552=9 THEN V4552=.;
IF V4553=99 THEN V4553=.;
IF V4554=99 THEN V4554=.;
IF V4555=9 THEN V4555=.;
IF V4556=9 THEN V4556=.;
IF V4557=99 THEN V4557=.;
IF V4558=9 THEN V4558=.;
IF V4559=99 THEN V4559=.;
IF V4560=9 THEN V4560=.;
IF V4561=9 THEN V4561=.;
IF V4562=99 THEN V4562=.;
IF V4563=9 THEN V4563=.;
IF V4564=99 THEN V4564=.;
IF V4565=9 THEN V4565=.;
IF V4566=99 THEN V4566=.;
IF V4567=9 THEN V4567=.;
IF V4568=99 THEN V4568=.;
IF V4569=9 THEN V4569=.;
IF V4570=99 THEN V4570=.;
IF V4571=99 THEN V4571=.;
IF V4572=99 THEN V4572=.;
IF V4573=9 THEN V4573=.;
IF V4574=9 THEN V4574=.;
IF V4575=9 THEN V4575=.;
IF V4576=9 THEN V4576=.;
IF V4577=99 THEN V4577=.;
IF V4578=99 THEN V4578=.;
IF V4579=99 THEN V4579=.;
IF V4580=99 THEN V4580=.;
IF V4581=99 THEN V4581=.;
IF V4582=99 THEN V4582=.;
IF V4583=9 THEN V4583=.;
IF V4584=9 THEN V4584=.;
IF V4585=9 THEN V4585=.;
IF V4586=99 THEN V4586=.;
IF V4587=9 THEN V4587=.;
IF V4588=9 THEN V4588=.;
IF V4589=9 THEN V4589=.;
IF V4590=9 THEN V4590=.;
IF V4591=999 THEN V4591=.;
IF V4592=9 THEN V4592=.;
IF V4593=9 THEN V4593=.;
IF V4594=9 THEN V4594=.;
IF V4595=9 THEN V4595=.;
IF V4596=9 THEN V4596=.;
IF V4597=9 THEN V4597=.;
IF V4598=9 THEN V4598=.;
IF V4599=9 THEN V4599=.;
IF V4600=9 THEN V4600=.;
IF V4601=9 THEN V4601=.;
IF V4602=9 THEN V4602=.;
IF V4604=9 THEN V4604=.;
IF V4605=99 THEN V4605=.;
IF V4606=99 THEN V4606=.;
IF V4607=99 THEN V4607=.;
IF V4608=99 THEN V4608=.;
IF V4609=99 THEN V4609=.;
IF V4610=9 THEN V4610=.;
IF V4611=9 THEN V4611=.;
IF V4612=9 THEN V4612=.;
IF V4613=9 THEN V4613=.;
IF V4615=9 THEN V4615=.;
IF V4616=9 THEN V4616=.;
IF V4617=9999 THEN V4617=.;
IF V4618=9 THEN V4618=.;
IF V4619=9 THEN V4619=.;
IF V4620=9 THEN V4620=.;
IF V4621=9 THEN V4621=.;
IF V4622=9 THEN V4622=.;
IF V4623=9 THEN V4623=.;
IF V4624=9 THEN V4624=.;
IF V4625=9 THEN V4625=.;
IF V4626=9 THEN V4626=.;
IF V4627=9 THEN V4627=.;
IF V4628=9 THEN V4628=.;
IF V4629=99 THEN V4629=.;
IF V4630=99 THEN V4630=.;
IF V4631=99 THEN V4631=.;
IF V4634=9 THEN V4634=.;
IF V4635=9 THEN V4635=.;
IF V4636=99 THEN V4636=.;
IF V4637=99 THEN V4637=.;
IF V4638=99 THEN V4638=.;
IF V4639=99 THEN V4639=.;
IF V4640=99 THEN V4640=.;
IF V4641=99 THEN V4641=.;
IF V4642=99 THEN V4642=.;
IF V4643=99 THEN V4643=.;
IF V4644=9 THEN V4644=.;
IF V4645=9 THEN V4645=.;
IF V4646_1=9 THEN V4646_1=.;
IF V4646_2=9 THEN V4646_2=.;
IF V4647=9 THEN V4647=.;
IF V4648=9 THEN V4648=.;
IF V4649=9 THEN V4649=.;
IF V4650_1=9 THEN V4650_1=.;
IF V4650_2=9 THEN V4650_2=.;
IF V4651=9 THEN V4651=.;
IF V4652=9 THEN V4652=.;
IF V4653=9 THEN V4653=.;
IF V4654=9 THEN V4654=.;
IF V4655=999 THEN V4655=.;
IF V4656=999 THEN V4656=.;
IF V4657=9 THEN V4657=.;
IF V4659=99 THEN V4659=.;
IF V4660=999 THEN V4660=.;
IF V4661=99 THEN V4661=.;
IF V4662=999 THEN V4662=.;
IF V4663=9 THEN V4663=.;
IF V4664=9 THEN V4664=.;
IF V4665=9 THEN V4665=.;
IF V4666=99 THEN V4666=.;
IF V4667=99 THEN V4667=.;
IF V4668=99 THEN V4668=.;
IF V4669=99 THEN V4669=.;
IF V4670=9 THEN V4670=.;
IF V4671=9 THEN V4671=.;
IF V4672=9 THEN V4672=.;
IF V4673=9 THEN V4673=.;
IF V4674=99 THEN V4674=.;
IF V4675=999 THEN V4675=.;
IF V4676=9 THEN V4676=.;
IF V4677=9 THEN V4677=.;
IF V4678=9 THEN V4678=.;
IF V4679=9 THEN V4679=.;
IF V4680=9 THEN V4680=.;
IF V4681=9 THEN V4681=.;
IF V4682=9 THEN V4682=.;
IF V4683=9 THEN V4683=.;
IF V4684=99 THEN V4684=.;
IF V4685=9 THEN V4685=.;
IF V4686=9 THEN V4686=.;
IF V4687=9 THEN V4687=.;
IF V4688=9 THEN V4688=.;
IF V4689=9 THEN V4689=.;
IF V4690=9 THEN V4690=.;
IF V4691=9 THEN V4691=.;
IF V4692=9 THEN V4692=.;
IF V4695=99 THEN V4695=.;
IF V4696=9 THEN V4696=.;
IF V4697=9 THEN V4697=.;
IF V4698=9 THEN V4698=.;
IF V4699=9 THEN V4699=.;
IF V4700=9 THEN V4700=.;
IF V4701=9 THEN V4701=.;
IF V4703=999 THEN V4703=.;
IF V4705=999 THEN V4705=.;
IF V4713=9999 THEN V4713=.;
IF V4714=9999 THEN V4714=.;
IF V4715=9999 THEN V4715=.;
IF V4716=9999 THEN V4716=.;
IF V4717=9999 THEN V4717=.;
IF V4718=9999 THEN V4718=.;
IF V4740=99 THEN V4740=.;
IF V4741=9 THEN V4741=.;
IF V4742=999 THEN V4742=.;
IF V4743=99 THEN V4743=.;
IF V4744=99 THEN V4744=.;
IF V4745=99 THEN V4745=.;
IF V4746=99 THEN V4746=.;
IF V4747=99 THEN V4747=.;
IF V4748=9 THEN V4748=.;
IF V4749=9 THEN V4749=.;
IF V4750=9 THEN V4750=.;
IF V4751=99 THEN V4751=.;
IF V4752=999 THEN V4752=.;
IF V4753=9 THEN V4753=.;
IF V4754=9 THEN V4754=.;
IF V4755=99 THEN V4755=.;
IF V4756=9 THEN V4756=.;
IF V4757=9 THEN V4757=.;
IF V4758=9 THEN V4758=.;
IF V4759=9 THEN V4759=.;
IF V4760=9 THEN V4760=.;
IF V4761=9 THEN V4761=.;
IF V4762=9 THEN V4762=.;
IF V4763=99 THEN V4763=.;
IF V4764=9 THEN V4764=.;
IF V4766=9 THEN V4766=.;
IF V4767=9 THEN V4767=.;
IF V4768=99 THEN V4768=.;
IF V4769=9 THEN V4769=.;
IF V4770=99 THEN V4770=.;
IF V4772=9 THEN V4772=.;
IF V4773=99 THEN V4773=.;
IF V4774=9 THEN V4774=.;
IF V4775=99 THEN V4775=.;
IF V4776=9 THEN V4776=.;
IF V4777=9 THEN V4777=.;
IF V4778=9 THEN V4778=.;
IF V4779_1 GE 9 THEN V4779_1=.;
IF V4779_2 GE 9 THEN V4779_2=.;
IF V4780=99 THEN V4780=.;
IF V4781=9 THEN V4781=.;
IF V4782=99 THEN V4782=.;
IF V4783=99 THEN V4783=.;
IF V4784=99 THEN V4784=.;
IF V4785=99 THEN V4785=.;
IF V4786=9 THEN V4786=.;
IF V4787=9 THEN V4787=.;
IF V4788=9 THEN V4788=.;
IF V4789=9 THEN V4789=.;
IF V4790=999 THEN V4790=.;
IF V4791=9 THEN V4791=.;
IF V4792=9 THEN V4792=.;
IF V4793=9 THEN V4793=.;
IF V4794=999 THEN V4794=.;
IF V4795=9 THEN V4795=.;
IF V4796=99 THEN V4796=.;
IF V4797=99 THEN V4797=.;
IF V4798=99 THEN V4798=.;
IF V4799=99 THEN V4799=.;
IF V4800=9 THEN V4800=.;
IF V4801=99 THEN V4801=.;
IF V4802=99 THEN V4802=.;
IF V4803=99 THEN V4803=.;
IF V4804=99 THEN V4804=.;
IF V4805=99 THEN V4805=.;
IF V4806=99 THEN V4806=.;
IF V4807=99 THEN V4807=.;
IF V4808=99 THEN V4808=.;
IF V4809=99 THEN V4809=.;
IF V4810=99 THEN V4810=.;
IF V4811=99 THEN V4811=.;
IF V4812=99 THEN V4812=.;
IF V4813=99 THEN V4813=.;
IF V4814=99 THEN V4814=.;
IF V4815=99 THEN V4815=.;
IF V4816=99 THEN V4816=.;
IF V4817=99 THEN V4817=.;
IF V4818=9 THEN V4818=.;
IF V4819=9 THEN V4819=.;
IF V4820=9 THEN V4820=.;
IF V4821=9 THEN V4821=.;
IF V4822=9 THEN V4822=.;
IF V4823=9 THEN V4823=.;
IF V4824=9 THEN V4824=.;
IF V4825=9 THEN V4825=.;
IF V4826=9 THEN V4826=.;
IF V4827=9 THEN V4827=.;
IF V4828=9 THEN V4828=.;
IF V4830=9 THEN V4830=.;
IF V4831=9 THEN V4831=.;
IF V4832=99 THEN V4832=.;
IF V4833=9 THEN V4833=.;
IF V4834=9 THEN V4834=.;
IF V4835=9 THEN V4835=.;
IF V4836=9 THEN V4836=.;
IF V4838=9 THEN V4838=.;
IF V4839=9 THEN V4839=.;
IF V4840_1=9 THEN V4840_1=.;
IF V4840_2=9 THEN V4840_2=.;
IF V4842=99 THEN V4842=.;
IF V4843=99 THEN V4843=.;
IF V4844=9 THEN V4844=.;
IF V4845=9 THEN V4845=.;
IF V4846=9 THEN V4846=.;
IF V4847=99 THEN V4847=.;
IF V4848=9 THEN V4848=.;
IF V4849=9 THEN V4849=.;
IF V4850=9 THEN V4850=.;
IF V4851=9 THEN V4851=.;
IF V4852=99 THEN V4852=.;
IF V4853=9 THEN V4853=.;
IF V4854=9 THEN V4854=.;
IF V4855=9 THEN V4855=.;
IF V4856=9 THEN V4856=.;
IF V4857=99 THEN V4857=.;
IF V4858=9 THEN V4858=.;
IF V4859=9 THEN V4859=.;
IF V4860=99 THEN V4860=.;
IF V4861=9 THEN V4861=.;
IF V4862=9 THEN V4862=.;
IF V4863=999 THEN V4863=.;
IF V4864=9 THEN V4864=.;
IF V4865=9 THEN V4865=.;
IF V4866=9 THEN V4866=.;
IF V4867=99 THEN V4867=.;
IF V4868=9 THEN V4868=.;
IF V4869=9 THEN V4869=.;
IF V4870=9 THEN V4870=.;
IF V4871=99 THEN V4871=.;
IF V4872=99 THEN V4872=.;
IF V4873=9 THEN V4873=.;
IF V4874=9 THEN V4874=.;
IF V4875=9 THEN V4875=.;
IF V4876=9 THEN V4876=.;
IF V4877=9 THEN V4877=.;
IF V4878=9 THEN V4878=.;
IF V4879=99 THEN V4879=.;
IF V4880=9 THEN V4880=.;
IF V4881=99 THEN V4881=.;
IF V4882=99 THEN V4882=.;
IF V4883=9 THEN V4883=.;
IF V4884=99 THEN V4884=.;
IF V4885=9 THEN V4885=.;
IF V4886=99 THEN V4886=.;
IF V4887=9 THEN V4887=.;
IF V4888=99 THEN V4888=.;
IF V4889=9 THEN V4889=.;
IF V4890=99 THEN V4890=.;
IF V4891=99 THEN V4891=.;
IF V4892=9 THEN V4892=.;
IF V4893=999 THEN V4893=.;
IF V4894=9 THEN V4894=.;
IF V4895=999 THEN V4895=.;
IF V4896=999 THEN V4896=.;
IF V4897=999 THEN V4897=.;
IF V4898=9 THEN V4898=.;
IF V4899=999 THEN V4899=.;
IF V4900=9 THEN V4900=.;
IF V4901=9 THEN V4901=.;
IF V4902=99 THEN V4902=.;
IF V4903=9 THEN V4903=.;
IF V4904=999 THEN V4904=.;
IF V4905=99 THEN V4905=.;
IF V4906=99 THEN V4906=.;
IF V4907=9 THEN V4907=.;
IF V4908=999 THEN V4908=.;
IF V4909=9 THEN V4909=.;
IF V4910=9 THEN V4910=.;
IF V4911=9 THEN V4911=.;
IF V4912=9 THEN V4912=.;
IF V4913=99 THEN V4913=.;
IF V4914=9 THEN V4914=.;
IF V4915=9 THEN V4915=.;
IF V4916=9 THEN V4916=.;
IF V4917=9 THEN V4917=.;
IF V4918=9 THEN V4918=.;
IF V4919=99 THEN V4919=.;
IF V4920=9 THEN V4920=.;
IF V4921=9 THEN V4921=.;
IF V4922=9 THEN V4922=.;
IF V4923=9 THEN V4923=.;
IF V4924=9 THEN V4924=.;
IF V4925=99 THEN V4925=.;
IF V4926=9 THEN V4926=.;
IF V4927=999 THEN V4927=.;
IF V4928=9 THEN V4928=.;
IF V4929=9 THEN V4929=.;
IF V4930=9 THEN V4930=.;
IF V4931=9 THEN V4931=.;
IF V4932=9 THEN V4932=.;
IF V4933=9 THEN V4933=.;
IF V4934=9 THEN V4934=.;
IF V4935=99 THEN V4935=.;
IF V4936=9 THEN V4936=.;
IF V4937=99 THEN V4937=.;
IF V4938=99 THEN V4938=.;
IF V4939=9 THEN V4939=.;
IF V4940=9 THEN V4940=.;
IF V4941=99 THEN V4941=.;
IF V4942=9 THEN V4942=.;
IF V4943=99 THEN V4943=.;
IF V4944=9 THEN V4944=.;
IF V4945=9 THEN V4945=.;
IF V4946=99 THEN V4946=.;
IF V4947=9 THEN V4947=.;
IF V4948=99 THEN V4948=.;
IF V4949=9 THEN V4949=.;
IF V4950=99 THEN V4950=.;
IF V4951=9 THEN V4951=.;
IF V4952=99 THEN V4952=.;
IF V4953=9 THEN V4953=.;
IF V4954=99 THEN V4954=.;
IF V4955=99 THEN V4955=.;
IF V4956=99 THEN V4956=.;
IF V4957=9 THEN V4957=.;
IF V4958=9 THEN V4958=.;
IF V4959=9 THEN V4959=.;
IF V4960=9 THEN V4960=.;
IF V4961=99 THEN V4961=.;
IF V4962=99 THEN V4962=.;
IF V4963=99 THEN V4963=.;
IF V4964=99 THEN V4964=.;
IF V4965=99 THEN V4965=.;
IF V4966=99 THEN V4966=.;
IF V4967=9 THEN V4967=.;
IF V4968=9 THEN V4968=.;
IF V4969=9 THEN V4969=.;
IF V4970=99 THEN V4970=.;
IF V4971=9 THEN V4971=.;
IF V4972=9 THEN V4972=.;
IF V4973=9 THEN V4973=.;
IF V4974=9 THEN V4974=.;
IF V4975=999 THEN V4975=.;
IF V4976=9 THEN V4976=.;
IF V4977=9 THEN V4977=.;
IF V4978=9 THEN V4978=.;
IF V4979=9 THEN V4979=.;
IF V4980=9 THEN V4980=.;
IF V4981=9 THEN V4981=.;
IF V4982=9 THEN V4982=.;
IF V4983=9 THEN V4983=.;
IF V4984=9 THEN V4984=.;
IF V4985=9 THEN V4985=.;
IF V4986=9 THEN V4986=.;
IF V4987=9 THEN V4987=.;
IF V4988=9 THEN V4988=.;
IF V4989=99 THEN V4989=.;
IF V4990=99 THEN V4990=.;
IF V4993=99 THEN V4993=.;
IF V4994=9 THEN V4994=.;
IF V4995=9 THEN V4995=.;
IF V4996=9 THEN V4996=.;
IF V4997=99 THEN V4997=.;
IF V4998=99 THEN V4998=.;
IF V4999=99 THEN V4999=.;
IF V5000=99 THEN V5000=.;
IF V5001=99 THEN V5001=.;
IF V5002=99 THEN V5002=.;
IF V5003=99 THEN V5003=.;
IF V5004=99 THEN V5004=.;
IF V5005=9 THEN V5005=.;
IF V5006=9 THEN V5006=.;
IF V5007_1 GE 9 THEN V5007_1=.;
IF V5007_2 GE 9 THEN V5007_2=.;
IF V5008=9 THEN V5008=.;
IF V5009=9 THEN V5009=.;
IF V5010=9 THEN V5010=.;
IF V5011_1 GE 9 THEN V5011_1=.;
IF V5011_2 GE 9 THEN V5011_2=.;
IF V5012=9 THEN V5012=.;
IF V5013=9 THEN V5013=.;
IF V5014=9 THEN V5014=.;
IF V5015=9 THEN V5015=.;
IF V5016=999 THEN V5016=.;
IF V5017=999 THEN V5017=.;
IF V5018=9 THEN V5018=.;
IF V5019=9 THEN V5019=.;
IF V5020=9 THEN V5020=.;
IF V5021=9 THEN V5021=.;
IF V5022=9 THEN V5022=.;
IF V5023=9 THEN V5023=.;
IF V5024=9 THEN V5024=.;
IF V5025=9 THEN V5025=.;
IF V5026=9 THEN V5026=.;
IF V5027=9 THEN V5027=.;
IF V5055=9 THEN V5055=.;
IF V5056=9 THEN V5056=.;
IF V5057=9 THEN V5057=.;
IF V5058=9 THEN V5058=.;
IF V5062=99999 THEN V5062=.;
IF V5063=9 THEN V5063=.;
IF V5064=9 THEN V5064=.;
IF V5065=9 THEN V5065=.;
IF V5066=9 THEN V5066=.;
IF V5067=9 THEN V5067=.;
IF V5068=9.9 THEN V5068=.;
IF V5069=9 THEN V5069=.;
IF V5072=9 THEN V5072=.;
IF V5073=9 THEN V5073=.;
IF V5074=9 THEN V5074=.;
IF V5075=9 THEN V5075=.;
IF V5096=9 THEN V5096=.;
IF V5100=9 THEN V5100=.;
IF V5101=9 THEN V5101=.;
IF V5102=9 THEN V5102=.;
IF V5103=9 THEN V5103=.;
IF V5104=9 THEN V5104=.;
IF V5105=9 THEN V5105=.;
IF V5106=9 THEN V5106=.;
IF V5107=9 THEN V5107=.;
IF V5108=9 THEN V5108=.;
IF V5109=9 THEN V5109=.;
IF V5110=9 THEN V5110=.;
IF V5111=9 THEN V5111=.;
IF V5112=9 THEN V5112=.;
 
file rawdat lrecl=1466;
put    
v4302
v4310
v4318
v4319
v4320
v4326
v4327
v4332
v4333
v4334
v4336
v4344
v4345
v4349
v4354
v4355
v4359
v4360
v4361
v4364
v4365
v4368
v4369
v4378
v4379
v4380
v4384
v4385
v4386
v4390
v4391
v4404
v4405
v4406
v4408
v4409
v4419
v4433
v4435
v4436
v4437
v4438
v4446
v4450
v4452
v4453
v4454
v4458
v4461
v4480
v4490
v4507
v4508
v4551
v4556
v4570
v4571
v4603
v4607
v4608
v4619
v4621
v4625
v4658
v4684
v4690
v4695
v4698
v4721
v4723
v4776
v4841
v4844
v4863
v4873
v4935
v4940
v4954
v4955
v5029
v5031
v5054
v5059
v5074
v5075
v5096
v5099
v30197
;

 proc means;
 run; 
